/** @file   enterhighscoresmenu.cpp
 * @brief   Implementation of EnterHighscoresMenu.cpp
 * @version $Revision: 1.4 $
 * @author  Tomi Lamminsaari
 */

#include "enterhighscoresmenu.h"
#include "consts.h"
#include "GfxManager.h"
#include "eng2d.h"
#include "soundsamples.h"
#include "GfxId.h"
using namespace eng2d;

namespace WeWantWar {

/** Constructor
 */
EnterHighscoresMenu::EnterHighscoresMenu( int scores ) :
  HighscoresMenu(),
  m_scores( scores ),
  m_highscoretable( Consts::HIGHSCOREFILE_NAME ),
  m_highscoremode( HSMODE_VIEW ),
  m_editedName( "          " ),
  m_cursorPos( 0 )
{
  this->initMenu();
  
}

/** Destructor
 */
EnterHighscoresMenu::~EnterHighscoresMenu()
{
}


/** redraws this menupage
 */
void EnterHighscoresMenu::redraw()
{
  blit( GfxManager::titlePic, Display::buffer, 420,0, 420,0, 220,480 );
  HighscoresMenu::redraw();
  
  if ( this->getState() == MenuPage::STATE_VISIBLE ) {
    if ( m_highscoremode == HSMODE_ENTER ) {
      // Show the enter your name window
      BITMAP* pS = GfxManager::findBitmap( GfxId::KMenuSmallWindow );
      int sx = 320 - ( pS->w / 2 );
      int sy = 240 - ( pS->h / 2 );
      draw_sprite( Display::buffer, pS, sx, sy );
      BMFont* titleFont = GfxManager::titleFont;
      TPrinter out( Display::buffer );
      out.font( titleFont, "normal30" );
      out.align( TPrinter::ALIGN_CENTER );
      out.pos( 320,200 );
      out.print( "your name" );
      
      out.font( titleFont, "menuitems" );
      out.align( TPrinter::ALIGN_RIGHT );
      out.pos( 350,150 );
      out.print( "your score" );
      
      out.font( titleFont, "menuitems_sel" );
      out.align( TPrinter::ALIGN_LEFT );
      out.pos( 370,150 );
      out.print( m_scores );
      
      // Print the name
      out.align( TPrinter::ALIGN_CENTER );
      out.pos( 320, 240 );
      out.print( m_editedName );
    }
  }
}




///
/// Getter methods
/// ==============




///
/// Private or Protected methods
/// ============================

/** Inits this menu
 */
void EnterHighscoresMenu::initMenu()
{
  if ( m_highscoretable.getPosition( m_scores ) < 0 ) {
    m_highscoremode = HSMODE_VIEW;
  } else {
    m_highscoremode = HSMODE_ENTER;
  }
}




/** Updates the fadein part
 */
int EnterHighscoresMenu::updateFadeInState()
{
  HighscoresMenu::updateFadeInState();
  clear_keybuf();
  return MenuPage::NO_PAGE_CHANGE;
}



/** updates the visible part
 */
int EnterHighscoresMenu::updateVisibleState()
{
  if ( key[MenuPage::s_lastKey] ) {
    return MenuPage::NO_PAGE_CHANGE;
  }
  MenuPage::s_lastKey = KEY_ESC;
  
  if ( m_highscoremode == HSMODE_VIEW ) {
    if ( key[KEY_ENTER] ) {
      MenuPage::s_lastKey = KEY_ENTER;
    } else if ( key[KEY_SPACE] ) {
      MenuPage::s_lastKey = KEY_SPACE;
    }
    
    if ( key[KEY_ENTER] || key[KEY_SPACE] ) {
      MenuPage::m_state = MenuPage::STATE_FADEOUT;
      Sound::playSample( SMP_MENUSELECT, false );
    }
    
  } else {
    // allow player to write his name
    if  ( key[KEY_ENTER] ) {
      m_highscoremode = HSMODE_VIEW;
      MenuPage::s_lastKey = KEY_ENTER;
      m_highscoretable.suggestEntry( m_scores, m_editedName );
      m_highscoretable.save();
      this->cleanupGraphics();
      this->createGraphics();
      MenuPage::m_state = MenuPage::STATE_FADEIN;
      Sound::playSample( SMP_MENUSELECT, false );
      
    } else {
      this->editText();
    }
  }
  return MenuPage::NO_PAGE_CHANGE;
}



/** Reads keyboard and edits the text
 */
void EnterHighscoresMenu::editText()
{
  if ( keypressed() ) {
    Sound::playSample( SMP_MENUITEM, false );
    int c = readkey();
    clear_keybuf();
    int scancode = c >> 8;
    if (scancode == KEY_BACKSPACE ) {
      if ( m_cursorPos > 0 ) {
        m_editedName[ m_cursorPos - 1 ] = ' ';
        m_cursorPos -= 1;
      }
      return;
    }
    
    
    char character = static_cast<char>( c & 0xff );
    character = tolower( character );
    
    if ( m_cursorPos >= m_editedName.length() ) {
      return;
    }
    if ( character >= 'a' && character <= 'z' ||
         character >= '0' && character <= '9' || character == ' ' ) {
      m_editedName[m_cursorPos] = character;
      m_cursorPos += 1;
    }
  }
}

} // end of namespace
